%------------------------------------------------------------------------------
% File     : SEV305^5 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Set Theory
% Problem  : TPS problem THM2
% Version  : Especial.
% English  : This is a fixed point theorem for sets. Assume K is a monotonic
%            operator on sets with respect to inclusion and conclude that K
%            has a fixed point. Taken from [Kol67]. Related to the Knaster-
%            Tarski theorem.

% Refs     : [Kol67] Kolodner (1967), A Simple Proof of the Schroder-Bernst
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0252 [Bro09]
%          : THM2 [TPS]

% Status   : Theorem
% Rating   : 0.92 v7.4.0, 0.89 v7.3.0, 0.90 v7.2.0, 0.88 v7.1.0, 0.86 v7.0.0, 0.88 v6.4.0, 0.86 v6.3.0, 0.83 v5.5.0, 0.80 v5.4.0, 0.75 v4.1.0, 0.67 v4.0.0
% Syntax   : Number of formulae    :    1 (   0 unit;   0 type;   0 defn)
%            Number of atoms       :   15 (   0 equality;  15 variable)
%            Maximal formula depth :   10 (  10 average)
%            Number of connectives :   14 (   0   ~;   0   |;   0   &;   9   @)
%                                         (   1 <=>;   4  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    2 (   0   :;   0   =)
%            Number of variables   :    7 (   0 sgn;   6   !;   1   ?;   0   ^)
%                                         (   7   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : Polymorphic definitions expanded.
%------------------------------------------------------------------------------
thf(cTHM2_pme,conjecture,(
    ! [K: ( $i > $o ) > $i > $o] :
      ( ! [Xx: $i > $o,Xy: $i > $o] :
          ( ! [Xx0: $i] :
              ( ( Xx @ Xx0 )
             => ( Xy @ Xx0 ) )
         => ! [Xx0: $i] :
              ( ( K @ Xx @ Xx0 )
             => ( K @ Xy @ Xx0 ) ) )
     => ? [Xu: $i > $o] :
        ! [Xx: $i] :
          ( ( K @ Xu @ Xx )
        <=> ( Xu @ Xx ) ) ) )).

%------------------------------------------------------------------------------
